﻿<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kalend" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Błędy RCP</TITLE>
		<script runat="server">
		    
            public class Item: IComparable<Item> {

                readonly Pracownik pracownik;
                public Pracownik Pracownik { get { return pracownik; } }
                readonly Date data;
                public Date Data { get { return data; } }
                readonly bool rcperror;
                public bool RCPError { get { return rcperror; } } 
                public Item(Pracownik pracownik, Date data, bool rcperror) {
                    this.pracownik = pracownik;
                    this.data = data;
                    this.rcperror = rcperror;
                }

                public int CompareTo(Item other) {
                    int i = Pracownik.CompareTo(other.Pracownik);
                    if (i == 0)
                        i = Data.CompareTo(other.Data);
                    return i;
                }
            }    
		    		
       void OnContextLoad(Object sender, EventArgs args) {
           Row[] rows = (Row[])dc[typeof(Row[])];
           FromTo parsokres = ((OkresContext)dc[typeof(OkresContext)]).Okres;

           System.Collections.Generic.List<Item> items = new System.Collections.Generic.List<Item>();
           
           KalendModule kalend = KalendModule.GetInstance(dc);
           foreach (Pracownik idx in rows) {

               Periods planPracy = Periods.New(parsokres);
               Periods okresZatrudniena = Periods.Empty;

               //Usuwamy okresy niezatrudnienia i interpretacji wg planu
               //Budujemy okresy zatrudnienia dla potrzeb błędów RCP
               foreach (PracHistoria ph in idx.Historia.GetIntersectedRows(parsokres)) {
                   FromTo eo = ph.Etat.EfektywnyOkres;
                   okresZatrudniena += eo * parsokres;
                   if (eo == FromTo.Empty || ph.Etat.InterpretacjaKalendarza == InterpretacjaKalendarza.WgPlanu)
                       planPracy -= ph.Aktualnosc;
                   else {
                       Periods niezatr = Periods.New(ph.Aktualnosc) - ph.Etat.Okres;
                       planPracy -= niezatr;

                       if (ph.Etat.InterpretacjaKalendarza == InterpretacjaKalendarza.WgZestawien)
                           foreach (ZestawieniePracy zp in idx.Zestawienia.GetIntersectedRows(ph.Etat.EfektywnyOkres))
                               planPracy -= zp.Okres;
                   }
               }

               KalkulatorPlanu plan = new KalkulatorPlanu(idx);
               plan.LoadOkres(parsokres);

               KalkulatorPracy praca = new KalkulatorPracy(plan);
               
               //Usuwamy okresy nieobecności               
               foreach (OkresNieobecności on in praca.Nieobecnosci(parsokres, true))
                   planPracy -= on.Okres;
                              
               //Budujemy dni planu
               Set<Date> dniPlanu = new Set<Date>();
               Set<Date> błędyRCP = new Set<Date>();
               foreach (FromTo okres in planPracy)
                   foreach (Date data in okres)
                       if (plan[data].Czas > Time.Zero)
                           dniPlanu.Add(data);

               //Usuwamy wprowadzone poprawne dni i dodajemy dni z błędami RCP
               SubTable dnipracy = idx.DniPracy[parsokres];
               foreach (DzienPracy dp in dnipracy)
                   if (dp.RcpOK)
                       dniPlanu.Remove(dp.Data);
                   else if (okresZatrudniena.Contains(dp.Data)) {
                       błędyRCP.Add(dp.Data);
                       dniPlanu.Add(dp.Data);
                   }               

               foreach (Date data in dniPlanu)
                   items.Add(new Item(idx, data, błędyRCP.Contains(data)));
           }

           items.Sort();
           Grid.DataSource = items;
       }

       protected void Grid_BeforeRow(object sender, RowEventArgs args) {
           Item item = (Item)args.Row;
           colOpis.EditValue = item.RCPError ? "Niejednoznaczne zapisy RCP" : "Brak informacji o czasie pracy";
       }
		    	   
       public static void Msg(object value) {
       }

</script>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server" 
                title="Błędy kalendarza obecności|&lt;/strong&gt;Wydział:&lt;strong&gt; {0}|&lt;/strong&gt;Pośrednio:&lt;strong&gt; {1}|&lt;/strong&gt;Okres:&lt;strong&gt; {2}|&lt;/strong&gt;Aktualny:&lt;strong&gt; {3}" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Kalend.DzienPracy,Soneta.KadryPlace"
				GroupLine="{0}" GroupData0="Pracownik" onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP."></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Data" Caption="Data"></ea:GridColumn>
				    <ea:GridColumn runat="server" Caption="Opis problemu" ID="colOpis">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

